<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class My_Button_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'my_button';
    }

    public function get_title() {
        return __( 'Download Button', 'text-domain' );
    }

    public function get_icon() {
          return 'myicon-custom-minimal'; // Utiliser la valeur de l'icône personnalisée minimaliste
    }

    public function get_categories() {
        return [ 'basic' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'text-domain' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

$this->add_control(
    'downloadable_file',
    [
        'label' => __( 'Downloadable File', 'my-elementor-addon' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'media_types' => [
            'application/pdf',
            'application/msword',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-excel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'application/vnd.ms-powerpoint',
            'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'audio/mpeg',  // MP3
            'audio/ogg'    // OGG
        ],
        'default' => [],
        'separator' => 'after',
    ]
);

        $this->add_control(
            'label',
            [
                'label' => __( 'Button Label', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Download', 'text-domain' ),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .my-button-text',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => esc_html__( 'Icon', 'elementor' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-file-pdf',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-button-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .my-button-icon svg' => '--icon-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .my-button-file' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'enable_fileName',
            [
                'label' => __( 'Enable File name', 'my-elementor-addon' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'my-button' ),
                'label_off' => __( 'No', 'my-button' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'filename_styles',
            [
                'label' => __( 'File Name Styles', 'my-elementor-addon' ),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button' => 'padding-bottom: 50px !important;',
                    '{{WRAPPER}} .fileName' => 'display: block; opacity: 1;',
                ],
                'condition' => [
                    'enable_fileName' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'largeur_filename',
            [
                'label' => esc_html__( 'FileName BOX width', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'condition' => [
                    'enable_fileName' => 'yes',
                ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .fileName' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'enable_fileinfo',
            [
                'label' => __( 'Enable File info', 'my-elementor-addon' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'my-button2' ),
                'label_off' => __( 'No', 'my-button2' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'enable_logo',
            [
                'label' => __( 'Enable Logo', 'my-elementor-addon' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'my-button2' ),
                'label_off' => __( 'No', 'my-button2' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'logo_image',
            [
                'label' => __( 'Logo Image', 'elementor-pdf-widget' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'enable_logo' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'logo_zoom',
            [
                'label' => __( 'Logo Size', 'elementor-pdf-widget' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'condition' => [
                    'enable_logo' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .buttonlogo' => 'width: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        
     $this->add_control(
            'enable_texture',
            [
                'label' => __( 'Enable texture', 'my-elementor-addon' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'my-button2' ),
                'label_off' => __( 'No', 'my-button2' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        
            $this->add_control(
            'texture_image',
            [
                'label' => __( 'Texture Image', 'elementor-pdf-widget' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'enable_texture' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button .texture-overlay' => 'content: ""; background-image: url({{URL}}); background-size: cover; position: absolute; top: 0; right: 0; bottom: 0; left: 0; z-index: 1;',
                ],
            ]
        );    
        

$this->add_control(
            'texture_opacity',
            [
                'label' => __( 'Texture Opacity', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 20,
                ],
                'condition' => [
                    'enable_texture' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button .texture-overlay' => 'opacity: {{SIZE}}%;',
                ],
            ]
        );      
        
        
        
        
        
        
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => esc_html__( 'Icon', 'elementor' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon-color',
            [
                'label' => __( 'Icon Color', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .my-button-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .my-button-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box-color',
            [
                'label' => __( 'Box Color', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0A3146',
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'text-color',
            [
                'label' => __( 'Text Color', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .my-button-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filenameBG-color',
            [
                'label' => __( 'FileName BOX Color', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff59',
                'selectors' => [
                    '{{WRAPPER}} .fileName' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filename-color',
            [
                'label' => __( 'FileName TEXT Color', 'text-domain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'espace_icon',
            [
                'label' => esc_html__( 'Icon Horizontal spacing', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-button-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'espace_logo',
            [
                'label' => esc_html__( 'Logo Spacing', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .buttonlogo' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'espace_icon_vert',
            [
                'label' => esc_html__( 'Bottom Vertical spacing', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button' => 'padding-bottom: {{SIZE}}{{UNIT}} ;',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_responsive_control(
            'espace_titre',
            [
                'label' => esc_html__( 'Espace Titre', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-button-text' => 'margin-right: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'borderradius',
            [
                'label' => esc_html__( 'Border radius', 'elementor' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 7,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-button' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .my-custom-button .texture-overlay' => 'border-radius: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
        $is_new = empty( $settings['icon'] ) && \Elementor\Icons_Manager::is_migration_allowed();

        $this->add_render_attribute( 'icon-wrapper', 'class', 'my-button-icon' );

        $icon_size = $settings['icon_size']['size'] ?? 25;
        $icon_class = 'icon-size-' . $icon_size;

        $file_url = ! empty( $settings['downloadable_file']['url'] ) ? esc_url( $settings['downloadable_file']['url'] ) : '#';
        $file_name = $file_url !== '#' ? basename( $file_url ) : 'fileName placeholder';

        $file_path = ABSPATH . str_replace( home_url(), '', $file_url );
        $file_extension = ! empty( pathinfo( $file_path, PATHINFO_EXTENSION ) ) ? pathinfo( $file_path, PATHINFO_EXTENSION ) : 'file placeholder';
        $file_size = file_exists( $file_path ) ? filesize( $file_path ) : '--Ko';

        $logo_url = ! empty( $settings['logo_image']['url'] ) ? $settings['logo_image']['url'] : '';
        $zoom = ! empty( $settings['logo_zoom']['size'] ) ? $settings['logo_zoom']['size'] : 100;
        
        $enable_file_name = ! empty( $settings['enable_fileName'] ) ? ( $settings['enable_fileName'] ) : 'no';

        // Convertir la taille du fichier en format lisible
        if ( $file_size > 0 ) {
            $file_size = size_format( $file_size );
        }

        $button_content = esc_html( $settings['label'] );
        $button_info = '(' . esc_html( $file_extension ) . ' : ' . esc_html( $file_size ) . ')';

        if ( empty( $settings['icon'] ) && ! \Elementor\Icons_Manager::is_migration_allowed() ) {
            $settings['icon'] = 'far fa-file';
        }

        if ( ! empty( $settings['icon'] ) ) {
            $this->add_render_attribute( 'icon', 'class', $settings['icon'] );
            $this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
        }

        echo '<div class="button-container">';
        echo '<a href="' .  esc_url($file_url) . '">';
        echo '<div class="my-custom-button">  
              <div class="texture-overlay"></div>';

        echo '<span class="my-button-icon ' . esc_attr( $icon_class ) . '">';

        if ( $is_new || $migrated ) {
            \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
        } else {
            echo '<div ' . esc_attr($this->print_render_attribute_string( 'icon' )) . '></div>';
        }

        echo '</span>';

        echo "<span class='my-button-text'>" . esc_html( $button_content ) . "</span>";

        if ( 'yes' === $settings['enable_fileinfo'] ) {
            echo "<span class='my-button-info'>" . esc_html( $button_info ) . "</span>";
        }

        if ( ! empty( $logo_url ) ) {
            echo '<span class="buttonlogo" style="width:' . esc_attr( $zoom ) . '"><img src="' . esc_url( $logo_url ) . '" style="width: 100%;"></span>';
        }

        if ( 'yes' === $enable_file_name ) {
            echo "<div class='fileName'><span class='name'>" . esc_html( $file_name ) . "</span></div>";
        }

        echo '</div>';
        echo '</a>';
        echo '</div>';
    }

    protected function _content_template() {
        ?>
        <#
        var button_content = settings.label;
        var is_filename = settings.enable_fileName === 'yes' ? 'yes' : 'no';
        var is_fileinfo = settings.enable_fileinfo;
        var fileUrl = settings.downloadable_file.url ? settings.downloadable_file.url : '#';
        var fileName = fileUrl !== '#' ? fileUrl.split('/').pop() : 'fileName placeholder';
        var fileExtension = fileUrl.split('.').pop() != "" ? fileUrl.split('.').pop() : "extension";
        var fileSize = '--Ko'; // Vous devrez obtenir la taille du fichier via une requête AJAX car JS ne peut pas accéder directement aux fichiers.

        var iconHTML = elementor.helpers.renderIcon( view, settings.selected_icon, { 'aria-hidden': true }, 'i', 'object' );
        var migrated = elementor.helpers.isIconMigrated( settings, 'selected_icon' );

        var is_logo = settings.enable_logo === 'yes' ? 'yes' : 'no';
        if ( is_logo === 'yes' ) {
            var logo_url = settings.logo_image.url;
            var logo_size = settings.logo_zoom.size;
            var logo_unit = settings.logo_zoom.unit;
        }
        #>
        <div class="button-container">
            <div class="my-custom-button"> 
              <div class="texture-overlay"></div>
                <# if ( iconHTML && iconHTML.rendered && ( ! settings.icon || migrated ) ) { #>
                    <span class="my-button-icon">{{{ iconHTML.value }}}</span>
                <# } else { #>
                    <div class="my-button-icon {{ settings.icon }}" aria-hidden="true"></div>
                <# } #>
                <span class='my-button-text'> {{{ button_content }}}</span>
                <# if ( is_fileinfo ) { #>
                    <span class='my-button-info'> ({{{ fileExtension }}} : {{{ fileSize }}}) </span>
                <# } #>
                <# if ( is_logo === "yes" ) { #>
                    <span class="buttonlogo" style="width: '{{{ logo_size }}}{{{ logo_unit }}}'"><img src="{{{ logo_url }}}" style="width: 100%;" /></span>
                <# } #>
                <# if ( is_filename ) { #>
                    <div class='fileName'><span class='name'>{{{ fileName }}}</span></div>
                <# } #>
            </div>
        </div>
        <?php
    }
}
