<?php
/**
 * Plugin Name: Download Button Widget for Elementor
 * Description: A custom button widget for Elementor.
 * Version: 1.0.3
 * Author: Vinz
 * @author      Vinz <dev@photolearn.fr>
 * @copyright   Copyright (C) 2024 Vinz DEV. All rights reserved.
 * license:GPLv2 or later
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// Ensure Elementor is active and loaded
add_action( 'plugins_loaded', 'mybuttonwidget_check_elementor_status' );

function mybuttonwidget_check_elementor_status() {
    if ( ! did_action( 'elementor/loaded' ) ) {
        add_action( 'admin_notices', 'mybuttonwidget_elementor_not_loaded_notice' );
        return;
    }

    // Enregistrer les widgets Elementor
    add_action( 'elementor/widgets/register', 'mybuttonwidget_register_widgets' );
    
    // Enqueue styles and scripts
    add_action( 'wp_enqueue_scripts', 'mybuttonwidget_enqueue_scripts' );
    
}

function mybuttonwidget_elementor_not_loaded_notice() {
    echo '<div class="notice notice-warning is-dismissible">
        <p>' . esc_html__( 'Elementor needs to be activated for My Button Widget to work.', 'my-button-widget' ) . '</p>
    </div>';
}

function mybuttonwidget_register_widgets( $widgets_manager ) {
    $widget_file = __DIR__ . '/widgets/my-button-widget.php';
    if ( file_exists( $widget_file ) ) {
        require_once( $widget_file );
        $widgets_manager->register( new \My_Button_Widget() );
    }
}

function mybuttonwidget_enqueue_scripts() {
    wp_enqueue_style( 'my-button-widget-style', plugins_url( 'css/style.css', __FILE__ ), [], '1.0.3' );
     wp_enqueue_style( 'my-custom-icons', plugins_url( 'css/custom-icons.css', __FILE__ ), [], '1.0.3' );
}


function my_plugin_frontend_stylesheets() {
    wp_register_style( 'frontend-style-1', plugins_url( '/css/custom-icons.css', __FILE__ ) , [], '1.0.3' );
    wp_enqueue_style( 'frontend-style-1' );
}
add_action( 'elementor/editor/after_enqueue_styles', 'my_plugin_frontend_stylesheets' );





